/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Changed r to be a macro for efficiency. TheEmu.

#define r(x) (fract(cos(dot(x,vec2(36.26,73.12)))*354.63))

const vec2 v00 = vec2(0.0,0.0);
const vec2 v01 = vec2(0.0,1.0);
const vec2 v10 = vec2(1.0,0.0);
const vec2 v11 = vec2(1.0,1.0);

float noise ( vec2 n )
 {
   vec2  fn = floor(n);
   vec2  sn = smoothstep ( v00, v11, fract(n) );
   float h1 = mix ( r(fn),    r(fn+v10), sn.x );
   float h2 = mix ( r(fn+v01),r(fn+v11), sn.x );
   return mix ( h1, h2, sn.y );
 }

float perlin ( vec2 n )
 {
  return noise ( n * 0.03125 ) * 0.5875
       + noise ( n * 0.06250 ) * 0.2000
       + noise ( n * 0.12500 ) * 0.1000
       + noise ( n * 0.25000 ) * 0.0500
       + noise ( n * 0.50000 ) * 0.0250
       + noise ( n           ) * 0.0125;
}

void main ( void )
 {
   // Rescaled n for better range of opacities. TheEmu.
   float n = 1.4*perlin(iGlobalTime*16.0+gl_FragCoord.xy*0.25);
   gl_FragColor = vec4(n,n,n,length(n));
 }